﻿/// <reference name="MicrosoftAjax.js"/>

Type.registerNamespace("ImageRotatorExtender");

ImageRotatorExtender.ImageRotator = function(element) {
    ImageRotatorExtender.ImageRotator.initializeBase(this, [element]);
    this._imageIndex = 0;
    this._imageList = null;
    this._rotationInterval = 3;
}

ImageRotatorExtender.ImageRotator.prototype = {
    initialize: function() {
        ImageRotatorExtender.ImageRotator.callBaseMethod(this, 'initialize');
        this._setupRotation();
    },
    dispose: function() {        
        ImageRotatorExtender.ImageRotator.callBaseMethod(this, 'dispose');
        this._imageList = null;
    },
    get_rotationInterval: function(){
        return this._rotationInterval;
    },
    set_rotationInterval: function(value){
        this._rotationInterval = value;
    },
    get_imageList: function(){
        return this._imageList;
    },
    set_imageList: function(value){
        this._imageList = value;
    },
    _setupRotation: function(){
        var expression = "$get('" + this.get_element().id + 
            "').ImageRotator._rotateImage()";
        setInterval(expression,this.get_rotationInterval()*1000);
    },
    _rotateImage: function(){
        var element = this.get_element();
        if(element)
        {
            element.src = this._imageList[this._imageIndex++];
            if(this._imageIndex > this._imageList.length - 1)
                this._imageIndex = 0;
        }
    }
}
ImageRotatorExtender.ImageRotator.registerClass(
    'ImageRotatorExtender.ImageRotator', Sys.UI.Behavior);

if (typeof(Sys) !== 'undefined') Sys.Application.notifyScriptLoaded();